/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.common;

import java.sql.SQLException;
import java.util.Date;
import java.util.List;

//import jp.mosp.base.AttendanceTotalAction;
import jp.mosp.payroll.common.vo.FirmBankingOutputVo;
import jp.mosp.payroll.dao.CmBranchDao;
import jp.mosp.payroll.dto.CmBranchDto;
import jp.mosp.payroll.dao.CmBankDao;
import jp.mosp.payroll.dto.CmBankDto;
import jp.mosp.payroll.dao.BankTransferDao;
import jp.mosp.payroll.dao.CmCoBankDao;
import jp.mosp.payroll.dao.CmCompanyDao;
import jp.mosp.payroll.dao.PdPayAllowanceDao;
import jp.mosp.payroll.dao.PdPayBreakdownDao;
import jp.mosp.payroll.dao.PdPayDeductionDao;
import jp.mosp.payroll.dao.PdPaySumDao;
import jp.mosp.payroll.dao.PdPayTimeDao;
import jp.mosp.payroll.dao.PhPaymentDao;
import jp.mosp.payroll.dao.PmDetailPaDao;
import jp.mosp.payroll.dao.PmDetailPbDao;
import jp.mosp.payroll.dao.PmDetailPdDao;
import jp.mosp.payroll.dao.PmDetailPsDao;
import jp.mosp.payroll.dao.PmDetailPtDao;
import jp.mosp.payroll.dto.BankTransferFBDataDto;
import jp.mosp.payroll.dto.CmCoBankDto;
import jp.mosp.payroll.dto.CmCompanyDto;
import jp.mosp.payroll.dto.PhPaymentDto;
import jp.mosp.payroll.base.Payment;
import jp.mosp.payroll.base.PayrollConst;
import jp.mosp.common.action.MosPAction;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.legal.LegalReportUtility;

public class PaymentFBDataOutputAction  extends MosPAction {
	// R}h
	private static final String CMD_PAYMENT_FB_DATA_OUTPUT = "P9002";
	
	/**
	 * RXgN^
	 */
	public PaymentFBDataOutputAction() {
		super();
		setNeedProcSeq(false);
	}
	
	int total  = 0;
	int amount = 0; 
	// ǉR[h
	int lenRecord = 0;
	/**
	 * ANV
	 */
	public void action() throws Exception {
		// DBRlNV擾
		getConnection();
		// PAYROLLmF
		confirmPayrollAuth();
		// VO̎擾
		FirmBankingOutputVo vo = (FirmBankingOutputVo)session.getAttribute(MospConst.ATT_FORMER_VO);
		vo.clearMessage();
		vo.clearErrField();
		vo.initVo(cfg, msg, cmd, aspUser, user);
		if (cmd.equals(CMD_PAYMENT_FB_DATA_OUTPUT)) {
			// p[^擾
			vo.setParams(request);
			// Џo^
			updateCompanyInfo(vo);
			// ǉR[h擾
			getAddRecordLength(Integer.parseInt(vo.getTxtRecordLength()));
			
			// Ώ۔N擾
			Date date = vo.getDate(vo.getPltSpecifyYear(), vo.getPltSpecifyMonth(), String.valueOf(PayrollConst.TIME_DEFAULT_DAY));
			// FBf[^擾
			BankTransferDao bankTransferDao = new BankTransferDao();
			bankTransferDao.initDao(cfg, cmd, aspUser, user, conn);	
			List<BankTransferFBDataDto> list = bankTransferDao.findForCondition(vo.getPltCoBankCode(), date, null, true);
			// [쐬
			StringBuffer sb = new StringBuffer();
			String fileName = vo.getPltSpecifyYear () + PayrollConst.FILE_NAME_SEPARATOR
							+ vo.getPltSpecifyMonth() + PayrollConst.FILE_NAME_SEPARATOR
							+ PayrollConst.FILE_FB_PAYMENT_DATA;
			request.setAttribute(MospConst.ATT_FILE_NAME, fileName);
			request.setAttribute(MospConst.ATT_FILE_OBJECT, sb);
			// ^f[^mF
			if (list.size() == 0) {
				String errMessage = MospUtility.getMessage(msg, PayrollConst.MSG_NO_PAYMENT, "");
				sb.append(errMessage);
				return;
			}
			//Uz̎擾
			getFrimAmo(list);
			// FBf[^쐬
			getFBDataRecord(sb, list, vo);
		}
	}
	
	/**
	 * FBf[^쐬
	 * @param sb
	 * @param list
	 * @throws Exception
	 */
	protected void getFBDataRecord(StringBuffer sb, List<BankTransferFBDataDto> list, FirmBankingOutputVo vo)
		throws Exception
	{
		// Ћs擾
		CmCoBankDao cmCoBankDao = new CmCoBankDao();
		cmCoBankDao.initDao(cfg, cmd, aspUser, user, conn);
		// ЋsR[hЈ̃Xg擾
		// Ћs擾
		CmCoBankDto	cmCoBankDto = cmCoBankDao.findForKey(vo.getPltCoBankCode());
		// ΏێЈł܂킷
		for (int j = 0; j < list.size(); j++) {
			BankTransferFBDataDto bankTransferFBDataDto = list.get(j);
			if (j == 0) {
				// wb_[R[hݒ
				setHeaderRecordData(sb, bankTransferFBDataDto, cmCoBankDto, vo);
			}
			// f[^R[hݒ
			setDataRecordData(sb, bankTransferFBDataDto, vo);
			// Xe[^XXV
			updatePaymentStatus(bankTransferFBDataDto);
		}
		// ׂĊmFIg[[R[hݒ
		LegalReportUtility.getTrailerRecord(sb, String.valueOf(total), String.valueOf(amount)
					, checkLineFeed(vo.getPltRecordType()), lenRecord);
		// GhR[h쐬
		// GhR[ho͊mF
		if (checkLineFeed(vo.getPltEndRecord())) {
			LegalReportUtility.getEndRecord(sb, checkLineFeed(vo.getPltRecordType()), lenRecord);
		}
		// 
		total = 0;
		amount = 0;
	}
	
	/**
	 * wb_[f[^ݒ
	 * @param sb
	 * @param aryBankCode
	 * @param aryBranchCode
	 * @param cmCompanyDto
	 * @param udPaymentDto
	 * @param cmCoBankDto
	 * @throws Exception 
	 */
	protected void setHeaderRecordData(
			StringBuffer sb, BankTransferFBDataDto bankTransferFBDataDto,CmCoBankDto cmCoBankDto,
			FirmBankingOutputVo vo
	) throws Exception {
		
		String[] aryBankName   = getBankName(cmCoBankDto.getBankCode());
		String[] aryBranchName = getBranchNameArray(cmCoBankDto.getBankCode(),cmCoBankDto.getBranchCode());
		
		// sݒ
		String coBankName   = aryBankName  [2];
		String coBranchName = aryBranchName[3];
		LegalReportUtility.getHeaderRecode(sb, PayrollConst.FB_PAYMENT_TYPE_CODE, vo.getPltCodeType(),
					vo.getTxtCompanyCode(), getLowerUpKana(vo.getTxtCompanyName())
					, String.valueOf(MospUtility.getMonth(bankTransferFBDataDto.getPayday())), String.valueOf(MospUtility.getDay(bankTransferFBDataDto.getPayday()))
					, cmCoBankDto.getBankCode   (), getLowerUpKana(coBankName)
					, cmCoBankDto.getBranchCode (), getLowerUpKana(coBranchName)
					, cmCoBankDto.getAccountType(), cmCoBankDto.getAccountNo()
					, checkLineFeed(vo.getPltRecordType()), lenRecord
			);
	}
	
	/**
	 * f[^R[hf[^ݒ
	 * @param sb
	 * @param bankTransferFBDataDto
	 * @throws Exception
	 */
	private void setDataRecordData(
		StringBuffer sb, BankTransferFBDataDto bankTransferFBDataDto, FirmBankingOutputVo vo
	) throws Exception {
		String[] aryBankName   = getBankName(bankTransferFBDataDto.getPaidBankCode());
		String[] aryBranchName = getBranchNameArray(bankTransferFBDataDto.getPaidBankCode(),bankTransferFBDataDto.getPaidBranchCode());

		// sݒ
		String bankName   = aryBankName  [2];
		String branchName = aryBranchName[3];
		String bankPayAmount = String.valueOf(bankTransferFBDataDto.getBankPayAmount());
		
		LegalReportUtility.getFBDataRecord(
			sb, bankTransferFBDataDto.getPaidBankCode(), getLowerUpKana(bankName)
			, bankTransferFBDataDto.getPaidBranchCode(), getLowerUpKana(branchName)
			, bankTransferFBDataDto.getAccountType(), bankTransferFBDataDto.getAccountNo()
			, getLowerUpKana(bankTransferFBDataDto.getHolderKana()) , bankPayAmount
			, bankTransferFBDataDto.getKCode(), bankTransferFBDataDto.getStationCode()
			, checkLineFeed(vo.getPltRecordType()), lenRecord
		);
		// ݒ
		total ++;
		// vzݒ
		amount +=  bankTransferFBDataDto.getBankPayAmount();

		
	}
	
	/**
	 * ^Xe[^XXV
	 * @param bankTransferFBDataDto
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	private void updatePaymentStatus(BankTransferFBDataDto bankTransferFBDataDto)
		throws SQLException, IllegalAccessException, NoSuchFieldException, MospException
	{
		// ^XV
		//UdPaymentDao udPaymentDao = new UdPaymentDao();
		//udPaymentDao.initDao(cfg, cmd, aspUser, user, conn);
		//UdPaymentDto udPaymentDto = udPaymentDao.findForKey(bankTransferFBDataDto.getKCode(), bankTransferFBDataDto.getCalcDate());
		//if (udPaymentDto != null) {
			// Xe[^XFBf[^o͍ς݂ɐݒ
		//	udPaymentDto.setCalcStatus(PayrollConst.CALC_STATUS_FB);
			// UD_PAYMENTXV
		//	udPaymentDao.update(udPaymentDto, true);
			// R~bg
		//	commit();
		//}
		
	}
	
	
	/**
	 * ЏXV
	 * @param vo
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	private void updateCompanyInfo(FirmBankingOutputVo vo) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		// DAO
		CmCompanyDao cmCompanyDao = new CmCompanyDao();
		cmCompanyDao.initDao(cfg, cmd, aspUser, user, conn);
		// ݊mF
		CmCompanyDto cmCompanyDto = cmCompanyDao.findAll();
		
		if (cmCompanyDto != null) {
			cmCompanyDto.setCompanyFbAddress(vo.getTxtCoAddress());
			cmCompanyDto.setCompanyFbKana(vo.getTxtCompanyName ());
			// XV
			cmCompanyDao.update(cmCompanyDto);
		} else {
			cmCompanyDto = new CmCompanyDto();
			cmCompanyDto.setCompanyFbAddress(vo.getTxtCoAddress());
			cmCompanyDto.setCompanyFbKana(vo.getTxtCompanyName ());
			// o^
			cmCompanyDao.insert(cmCompanyDto);
			
		}
		// R~bg
		commit();
	}
	
	
	/**
	 * st^mF
	 * @param strLineFeed
	 * @return
	 */
	private boolean checkLineFeed(String strLineFeed) {
		// R[h敪ɉsȂ
		if (strLineFeed.equals(PayrollConst.FB_RECORD_TYPE_NONE)) {
			return false;
		}
		// R[h敪ɉs
		return true;
	}
	
	/**
	 * ǉR[h擾
	 * @param addLenRecord
	 */
	private void getAddRecordLength(int addLenRecord) {
		// ǉR[h-120(ŏR[h)
		 lenRecord = addLenRecord - PayrollConst.FB_LOWER_LEN_RECORD;
		 if (lenRecord < 0) {
			 lenRecord = 0;
		 }
	}
	
	/**
	 * s擾(p\̂)(CM_BANK)
	 * @return sXg
	 * @throws Exception
	 */
	protected String[] getBankName(String bankCode) throws Exception {
		// 
		String[] aryBankName = new String[3];
		// DAȌ
		CmBankDao dao = new CmBankDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// ̎擾
		CmBankDto  cmBankDto = dao.findForKey(bankCode);
		// z̍쐬
		if (cmBankDto != null) {
			aryBankName[0] = cmBankDto.getBankCode();
			aryBankName[1] = cmBankDto.getBankName();
			aryBankName[2] = cmBankDto.getBankKana();
		} else {
			aryBankName[0] = bankCode;
			aryBankName[1] = bankCode;
			aryBankName[2] = bankCode;
			
		}
		
		return aryBankName;
	}
	
	/**
	 * xXR[h擾(p\̂)(CM_BANK)
	 * @return sR[hXg
	 * @throws Exception
	 */
	protected String[] getBranchNameArray(String bankCode, String branchCode) throws Exception {
		// 
		String[] aryBranchName = new String[4];
		// DAȌ
		CmBranchDao dao = new CmBranchDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// ̎擾
		CmBranchDto cmBranchDto = dao.findForKey(bankCode, branchCode);
		// z̍쐬
		if (cmBranchDto != null) {
			aryBranchName[0] = cmBranchDto.getBankCode();
			aryBranchName[1] = cmBranchDto.getBranchCode();
			aryBranchName[2] = cmBranchDto.getBranchName();
			aryBranchName[3] = cmBranchDto.getBranchKana();
		} else {
			aryBranchName[0] = bankCode;
			aryBranchName[1] = branchCode;
			aryBranchName[2] = branchCode;
			aryBranchName[3] = branchCode;
			
		}
		return aryBranchName;
	}
	
	/**
	 * pJiϊ(啶)
	 * @param strTarget
	 * @return@pJi
	 */
	protected String getLowerUpKana(String strTarget) {
		// pJi()
		String[] aryLowerKana = {
				"",  "", "", "", "", "", "", "", ""
		};
		// pJi(啶)
		String[] aryLowerUpKana = {
				"",  "", "", "", "", "", "", "", ""
		};
		// 
		String retString = "";
		String repString = "";
		// ̌ŉ
		for (int i = 0; i < strTarget.length(); i++) {
			// Ԃɕ擾Ă
			repString = strTarget.substring(i, i+1);
			// ԂɊmF
			for (int j = 0; j < aryLowerKana.length; j++) {
				// p()݂啶֕ϊ
				if (aryLowerKana[j].equals(repString)) {
					repString = aryLowerUpKana[j];
					break;
				}
			}
			// 
			retString += repString;
		}
		return retString;
	}
	
	/**
	 * U݋z̎擾
	 * @param list
	 */
	private void getFrimAmo(List<BankTransferFBDataDto> lineList) throws Exception {
		String oldkCode = "";
		String newkCode = "";
		
		for (int i = 0; i < lineList.size(); i++) {
			BankTransferFBDataDto list = lineList.get(i);
			
			newkCode = list.getKCode();
			if (!oldkCode.equals(newkCode)) {
				Payment sumAmo = getPayment(list.getKCode(), list.getCalcDate());
				int Amount = sumAmo.getSumAmount(PayrollConst.DTL_SUM_BANK1);
				list.setBankPayAmount(Amount);
			} else {
				Payment sumAmo = getPayment(list.getKCode(), list.getCalcDate());
				int Amount = sumAmo.getSumAmount(PayrollConst.DTL_SUM_BANK2);
				list.setBankPayAmount(Amount);
			}
			oldkCode = newkCode;
			
		}
		
	}
	
	/**
	 * ^`[CX^X擾Aݒ肷B<br><br>
	 * kCodeAcalcDateL[Ƃċ^擾A{@link #payment}Ɋi[B
	 * @param kCode     ЈR[h
	 * @param calcMonth vZN
	 * @return ^`[
	 * @throws NoSuchFieldException 
	 * @throws IllegalAccessException 
	 * @throws SQLException 
	 */
	protected Payment getPayment(
			String kCode, Date calcMonth
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		PhPaymentDto header = new PhPaymentDao(
				cfg, cmd, aspUser, user, conn).findForKey(kCode, calcMonth);
		if (header == null) {
			return null;
		}
		return new Payment(
				header,
				new PmDetailPtDao(cfg, cmd, aspUser, user, conn).findForSlip(header.getSlipCode()),
				new PmDetailPaDao(cfg, cmd, aspUser, user, conn).findForSlip(header.getSlipCode()),
				new PmDetailPdDao(cfg, cmd, aspUser, user, conn).findForSlip(header.getSlipCode()),
				new PmDetailPbDao(cfg, cmd, aspUser, user, conn).findForSlip(header.getSlipCode()),
				new PmDetailPsDao(cfg, cmd, aspUser, user, conn).findForSlip(header.getSlipCode()),
				new PdPayTimeDao     (cfg, cmd, aspUser, user, conn).find(kCode, calcMonth),
				new PdPayAllowanceDao(cfg, cmd, aspUser, user, conn).find(kCode, calcMonth),
				new PdPayDeductionDao(cfg, cmd, aspUser, user, conn).find(kCode, calcMonth),
				new PdPayBreakdownDao(cfg, cmd, aspUser, user, conn).find(kCode, calcMonth),
				new PdPaySumDao      (cfg, cmd, aspUser, user, conn).find(kCode, calcMonth)
		);
	}

}
